﻿var emailInvitationStatus = {
    context: $(".v-emailInvitationStatus"),
    datatable: null,
    initialize: function () {
        var distributionId = $(".distributionId").val();

        this.datatable = $(".h-invitation-history-table", emailInvitationStatus.context).a4datatable({            
            ajaxAction: a4.getSurveyAction("GetEmailDistributionRespondents", "Distribute"),
            ajaxParams: { "distributionId": distributionId },
            style: "compact",
            displayColumnSelector: false,
            displaySearchBox: canReadPII,
            columns: [
                { "Data": "EmailInvitationMessage", "Tooltip": true },
                { "Name": "RespondentId", "Title": resources.Id, "Data": "RespondentId", "Width": (canReadPII ? "70px" : "") },
                { "Name": "RespondentEmail", "Title": resources.Email, "Data": "RespondentEmail", "Visible": canReadPII, "HideInSelector": !canReadPII },
                { "Name": "EmailInvitationStatus", "Title": resources.Status, "Data": "EmailInvitationStatus", "Width": (canReadPII ? "100px" : "" ) },
                { "Name": "AccessDate", "Title": resources.SentDate, "Data": "AccessDate", "Width": (canReadPII ? "130px" : "" ) }
            ],
            quickFilter: {
                "AjaxParam": "status",
                "Items": [
                    { "Label": resources.Sent, "AjaxParams": { "status": '1' } },
                    { "Label": resources.Delivered, "AjaxParams": { "status": '6' } },
                    { "Label": resources.Undelivered, "AjaxParams": { "status": '3,9,10,11,12' } }
                ]
            }
        });

        if ($(".chart").length > 0) {
            a4.callServerMethod(a4.getSurveyAction("EmailDistributionStatusChart", "Distribute"), { id: distributionId }, function (result) {
                a4.initChart($(".chart"), result);
            });
        }
    },
    bindEvents: function () {
        emailInvitationStatus.context.on("click", ".h-exportRespondents", function () {
            a4.showBusyBox();

            var ajaxParams = emailInvitationStatus.datatable.a4datatable("getAjaxParams");

            a4.callServerMethod(a4.getSurveyAction("ExportEmailDistributionRespondents", "Distribute"), ajaxParams,
            function (result) {
                a4.hideBusyBox();
                window.location = a4.getSurveyAction("GetEmailDistributionRespondentsFile", "Distribute", { fileName: result });
            },
            function (error) {
                a4.onAjaxPageMethodError(error);
            });
        });
    }
}

$(document).ready(function () {
    if (emailInvitationStatus.context.length > 0) {
        emailInvitationStatus.initialize();
        emailInvitationStatus.bindEvents();
    }
});